﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Diagnostics;
using FDK;

namespace StrokeStyleT
{
	class CAct演奏判定文字列 : CActivity
	{
		public void t表示( E演奏レーン eレーン, E判定 e判定 )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( eレーン == E演奏レーン.Unknown )
				return;
			//-----------------
			#endregion

			// パッドに対応する状態構造体を設定。

			this.dic状態[ eレーン ].Dispose();
			this.dic状態[ eレーン ] = new C状態() {
				ct進行 = new CCounter( 0, 300, 1 ),
				judge = e判定,
				fX方向拡大率 = 1.0f,
				fY方向拡大率 = 1.0f,
				n相対X座標 = 0,
				n相対Y座標 = 0,
				n透明度 = 255,
			};
		}

		public override void On活性化()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してる )
				return;
			//-----------------
			#endregion

			foreach( var ePadObj in Enum.GetValues( typeof( E演奏レーン ) ) )
			{
				var eレーン = (E演奏レーン) ePadObj;
				if( eレーン == E演奏レーン.Unknown )
					continue;

				this.dic状態[ eレーン ] = new C状態() {
					ct進行 = new CCounter()
				};
			}

			base.On活性化();
		}
		public override void On非活性化()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			foreach( var ePadObj in Enum.GetValues( typeof( E演奏レーン ) ) )
			{
				var eレーン = (E演奏レーン) ePadObj;
				if( eレーン == E演奏レーン.Unknown )
					continue;

				Global.tDisposeする( this.dic状態[ eレーン ] );
				this.dic状態[ eレーン ] = null;
			}

			base.On非活性化();
		}
		public override void Onリソースの作成( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			this.tx判定文字列1 = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenPlay judge strings 1.png" ) );
			this.tx判定文字列2 = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenPlay judge strings 2.png" ) );
			this.tx判定文字列3 = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenPlay judge strings 3.png" ) );

			this.dic判定文字列画像 = new Dictionary<E判定, ST判定文字列>() {
				{ E判定.PERFECT, new ST判定文字列() { tx文字列テクスチャ = this.tx判定文字列1, rc文字列領域 = new Rectangle( 0, 0, 128, 42 ) } },
				{ E判定.GREAT, new ST判定文字列() { tx文字列テクスチャ = this.tx判定文字列1, rc文字列領域 = new Rectangle( 0, 43, 128, 42 ) } },
				{ E判定.GOOD, new ST判定文字列() { tx文字列テクスチャ = this.tx判定文字列1, rc文字列領域 = new Rectangle( 0, 86, 128, 42 ) } },
				{ E判定.POOR, new ST判定文字列() { tx文字列テクスチャ = this.tx判定文字列2, rc文字列領域 = new Rectangle( 0, 0, 128, 42 ) } },
				{ E判定.MISS, new ST判定文字列() { tx文字列テクスチャ = this.tx判定文字列2, rc文字列領域 = new Rectangle( 0, 43, 128, 42 ) } },
				{ E判定.AUTO, new ST判定文字列() { tx文字列テクスチャ = this.tx判定文字列3, rc文字列領域 = new Rectangle( 0, 0, 128, 42 ) } },
			};

			base.Onリソースの作成( hDevice );
		}
		public override void Onリソースの解放()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			Global.tDisposeする( ref this.tx判定文字列1 );
			Global.tDisposeする( ref this.tx判定文字列2 );
			Global.tDisposeする( ref this.tx判定文字列3 );

			base.Onリソースの解放();
		}
		public override int On進行()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return 0;
			//-----------------
			#endregion

			// すべての E演奏レーン について……

			foreach( var obj in Enum.GetValues( typeof( E演奏レーン ) ) )
			{
				var eレーン = (E演奏レーン) obj;

				if( eレーン == E演奏レーン.Unknown )
					continue;	// Unknown は無視。


				// 停止中なら何も進行しない。

				C状態 c状態 = this.dic状態[ eレーン ];

				if( c状態.ct進行.b停止中 )
					continue;


				// タイマ進行。

				if( c状態.ct進行.t進行().b終了値に達した )
				{
					c状態.ct進行.t停止();
					continue;
				}


				// 判定文字列アニメ進行。

				int n = c状態.ct進行.n現在の値;

				if( c状態.judge != E判定.MISS )
				{
					#region [ (A) Perfect, Great, Good, Poor, Auto のアニメーション進行。]
					//-----------------
					if( n < 50 )
					{
						c状態.fX方向拡大率 = 1.0f + ( 1.0f * ( 1.0f - ( ( (float) n ) / 50.0f ) ) );
						c状態.fY方向拡大率 = ( (float) n ) / 50.0f;
						c状態.n相対X座標 = 0;
						c状態.n相対Y座標 = 0;
						c状態.n透明度 = 255;
					}
					else if( n < 130 )
					{
						c状態.fX方向拡大率 = 1.0f;
						c状態.fY方向拡大率 = 1.0f;
						c状態.n相対X座標 = 0;
						c状態.n相対Y座標 = ( ( n % 6 ) == 0 ) ? ( Global.Random.Next( 6 ) - 3 ) : c状態.n相対Y座標;
						c状態.n透明度 = 255;
					}
					else if( n < 240 )
					{
						c状態.fX方向拡大率 = 1.0f;
						c状態.fY方向拡大率 = 1.0f;
						c状態.n相対X座標 = 0;
						c状態.n相対Y座標 = 0;
						c状態.n透明度 = 255;
					}
					else
					{
						c状態.fX方向拡大率 = 1.0f;
						c状態.fY方向拡大率 = 1.0f - ( ( 1.0f * ( n - 240 ) ) / 60.0f );
						c状態.n相対X座標 = 0;
						c状態.n相対Y座標 = 0;
						c状態.n透明度 = 255;
					}
					//-----------------
					#endregion
				}
				else
				{
					#region [ (B) Miss のアニメーション進行。]
					//-----------------
					if( n < 50 )
					{
						c状態.fX方向拡大率 = 1.0f;
						c状態.fY方向拡大率 = ( (float) n ) / 50.0f;
						c状態.n相対X座標 = 0;
						c状態.n相対Y座標 = 0;
						c状態.n透明度 = 255;
					}
					else if( n < 200 )
					{
						c状態.fX方向拡大率 = 1.0f;
						c状態.fY方向拡大率 = 1.0f;
						c状態.n相対X座標 = 0;
						c状態.n相対Y座標 = 0;
						c状態.n透明度 = 255;
					}
					else
					{
						c状態.fX方向拡大率 = 1.0f - ( ( (float) ( n - 200 ) ) / 100.0f );
						c状態.fY方向拡大率 = 1.0f - ( ( (float) ( n - 200 ) ) / 100.0f );
						c状態.n相対X座標 = 0;
						c状態.n相対Y座標 = 0;
						c状態.n透明度 = 255;
					}
					//-----------------
					#endregion
				}
			}

			return 0;
		}
		public override void On描画( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない ||
				this.tx判定文字列1 == null ||
				this.tx判定文字列2 == null ||
				this.tx判定文字列3 == null )
				return;
			//-----------------
			#endregion

			// すべての E演奏レーン について……

			foreach( var obj in Enum.GetValues( typeof( E演奏レーン ) ) )
			{
				var e演奏レーン = (E演奏レーン) obj;
			
				if( e演奏レーン == E演奏レーン.Unknown )
					continue;	// Unknown は無視。

				C状態 c状態 = this.dic状態[ e演奏レーン ];

				if( c状態.ct進行.b停止中 )
					continue;

				CTexture texture = this.dic判定文字列画像[ c状態.judge ].tx文字列テクスチャ;
				int w = texture.sz画像サイズ.Width;
				int h = texture.sz画像サイズ.Height / 3;	// テクスチャ１枚につき画像が縦３枚あるので、１枚の画像の縦幅は1/3になる。
				var pos = Theme.演奏.dic判定文字列の中心スクリーン座標px[ e演奏レーン ];
				pos.X += -(int) ( ( w * c状態.fX方向拡大率 ) / 2.0f ) + c状態.n相対X座標;
				pos.Y += -(int) ( ( h * c状態.fY方向拡大率 ) / 2.0f ) + c状態.n相対Y座標;
				texture.n透明度 = c状態.n透明度;
				texture.vc拡大縮小倍率 = new Vector3( c状態.fX方向拡大率, c状態.fY方向拡大率, 1.0f );
				texture.t2D描画( hDevice, pos, this.dic判定文字列画像[ c状態.judge ].rc文字列領域 );
			}
		}

		CTexture tx判定文字列1;
		CTexture tx判定文字列2;
		CTexture tx判定文字列3;

		class C状態 : IDisposable
		{
			public CCounter ct進行;
			public E判定 judge;
			public float fX方向拡大率;
			public float fY方向拡大率;
			public int n相対X座標;
			public int n相対Y座標;
			public int n透明度;

			public void Dispose()
			{
				Global.tDisposeする( ref this.ct進行 );
			}
		}
	
		Dictionary<E演奏レーン, C状態> dic状態 = new Dictionary<E演奏レーン, C状態>();

		struct ST判定文字列
		{
			public CTexture tx文字列テクスチャ;
			public Rectangle rc文字列領域;
		}
		Dictionary<E判定, ST判定文字列> dic判定文字列画像;
	}
}
